//
//  MCReportDataInfoPlugin.h
//  MCReporting
//
//  Created by Alykhan Jetha on 07/02/06.
//  Copyright 2006 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCReportElement;
@class MCReportGenerator;
@class MCReportDataInfo;

@interface MCReportDataInfoPlugin : NSObject {
	NSString *name;
	NSString *displayName;
	NSString *resultKindName; // entity or object name
	NSString *relativePrefix;
	BOOL isToMany;
}

// parent can nil (i.e a root table), default is yes.
+ (BOOL)canHandleParentOfKind:(NSString *)anEntityName;

- (id)initWithCoder:(NSCoder *)coder;
- (void)encodeWithCoder:(NSCoder *)coder;


- (NSString *)name;
- (void)setName:(NSString *)aName;

- (NSString *)displayName;
- (void)setDisplayName:(NSString *)aDisplayName;

- (NSString *)relativePrefix;
- (void)setRelativePrefix:(NSString *)aRelativePrefix;

- (NSString *)resultKindName;
- (void)setResultKindName:(NSString *)aResultKindName;

- (BOOL)isToMany;
- (void)setIsToMany:(BOOL)flag;

- (NSString *)shortUIName;

- (BOOL)keyPathContains:(NSString *)aKeyPath;
- (BOOL)replaceKeyPath:(NSString *)aKeyPath withKeyPath:(NSString *)aNewKeyPath;

- (Class)editorClass;

- (BOOL)needsCustomResultingFields;

- (id)evaluateForReportElement:(MCReportElement *)reportElement 
			   reportGenerator:(MCReportGenerator *)rgen
			   previousResults:(NSArray *)previousResults
					  dataInfo:(MCReportDataInfo *)dataInfo;

@end
